@extends('layouts.app')

@section('content')



<div class="panel panel-default">
    
    <div class="panel-heading">
        Inventario
    </div>
    
    <div class="panel-body">
    
        <form action="{{ url('reporte') }}" method="POST">
            
            {{ csrf_field() }}
            
            <div class="form-group">
                <label>Zona</label>
                <select name="zona" class="form-control" required autofocus>
                    <option value=""></option>
                    @foreach($zonas as $zona)
                        <option value="{{ $zona->id }}" {{ $zona->id==$zona_id?'selected':'' }}>{{ $zona->nombre }}</option>
                    @endforeach
                    <option value="0">TODAS</option>
                </select>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    Ver Inventario <i class="fa fa-arrow-right"></i>
                </button>
            </div>
            
        </form>
    
    </div>

</div>

@if(count($inventarios)>0)

<div class="panel panel-default">
    
    <div class="panel-heading">
        <b>Inventario  @if($zona_id==0) Todas las Zonas @else {{ App\Zona::find($zona_id)->nombre }} @endif</b>
        <button onclick="copiarTabla()" class="btn btn-success btn-xs pull-right">
            Copiar tabla <i class="fa fa-table" aria-hidden="true"></i>
        </button>
    </div>
    
    <table class="table table-bordered table-striped " id="tablaDatos">
        <thead class="table-light">
            <tr>
                <th>Linea</th>
                <th>Código</th>
                <th>Descripción</th>
                <th>Presentación</th>
                <th>Ida</th>
                <th>Vuelta</th>
                <!--<th></th>-->
            </tr>
        </thead>
        <tbody>
            @foreach($inventarios as $inventario)
            <tr>
                <td>{{ $inventario->linea }}</td>
                <td>{{ $inventario->codigo }}</td>
                <td>{{ $inventario->descripcion }}</td>
                <td>{{ $inventario->presentacion }}</td>
                <td align="right">{{ $inventario->ida }}</td>
                <td align="right">{{ $inventario->vuelta }}</td>
                <!--<td>
                    <form action="{{ url('/reporte/'.$inventario->id) }}" method="POST">
                        {{ csrf_field() }}
                        {{ method_field('DELETE') }}
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Seguro de eliminar?')">
                            <i class="fa fa-trash"></i>
                        </button>
                    </form>
                </td>-->
            </tr>
            @endforeach
        </tbody>
    </table>
    
    <!--<div class="panel-footer">
        <a onclik="window.history.back()" class="btn btn-primary"><i class="fa fa-arrow-left"></i> Regresar</a>
    </div>-->

</div>

@elseif($zona_id!='')

<p class="text-danger">No hay inventario en zona</p>

@endif

@endsection

<script>
function copiarTabla() {
    let texto = "";
    document.querySelectorAll("#tablaDatos tr").forEach(tr => {
        let fila = [];
        tr.querySelectorAll("th, td").forEach(td => {
            fila.push(td.innerText);
        });
        texto += fila.join("\t") + "\n";
    });

    navigator.clipboard.writeText(texto)
        .then(() => alert("Datos copiados"))
        .catch(err => console.error(err));
}
</script>