@extends('layouts.app')

@section('content')

<div class="panel panel-default">
    
    <div class="panel-heading">Registro de Inventario Vuelta</div>
    
    <div class="panel-body">
        
        @if ($producto->MatV_Desc == "")
            <p class="text-danger">No se encontro código de producto</p>
        @endif
        
        <form action="{{ url('registro2') }}" method="POST">
            
            {{ csrf_field() }}
            
            <input type="hidden" name="modo" value="{{ $modo }}">
            
            <div class="form-group">
                <label>Item:</label>
                <input type="number" name="orden" class="form-control" value="{{ $orden }}" required readonly>
            </div>
            
            <div class="form-group">
                <label>Código:</label>
                <input type="number" name="codigo" class="form-control" value="{{ $producto->MatV_Codigo }}" required readonly>
            </div>
            
            <div class="form-group">
                <label>Descripción:</label>
                <input type="text" name="descripcion" class="form-control" value="{{ $producto->MatV_Desc }}" required readonly>
            </div>
            
            <div class="form-group">
                <label>Presentación:</label>
                <input type="text" name="presentacion" class="form-control" value="{{ $producto->MatV_UMB }}" required readonly>
            </div>
            
            <div class="form-group">
                @if($producto->activo==1)
                    <label class="text-primary">Producto Activo</label>
                @else
                    <label class="text-danger">Producto Inactivo</label>
                @endif
            </div>
            
            <input type="hidden" name="lote" id="lote" value="">
            
            <div class="form-group">
                <label>Stock:</label>
                <input type="number" name="cantidad" class="form-control" value="{{ $inventario->stock2 }}" step="0.01" min="0.01" max="99999999.99" required>
            </div>
            
            <div class="form-group">
                <label>Ubicación:</label>
                <input type="text" name="ubicacion" class="form-control" value="{{ $inventario->ubicacion }}" oninput="this.value = this.value.toUpperCase();">
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Registrar
                </button>
                &nbsp;
                <a class="btn btn-danger" href="{{ url('busqueda2') }}">
                    <i class="fa fa-arrow-left"></i> Regresar
                </a>
            </div>
            
        </form>
    
    </div>
    
</div>

@endsection