@extends('layouts.app')

@section('content')

<div class="panel panel-default">
    
    <div class="panel-heading">Busqueda de producto</div>
    
    <div class="panel-body">

        <form action="{{ url('busqueda') }}" method="POST">
            
            {{ csrf_field() }}
            
            <input type="hidden" name="tipo" value="codigo">
            
            <div class="form-group">
                <label for="codigo">Código de Producto</label>
                <input type="number" id="codigo" name="codigo" class="form-control" value="{{ old('codigo') }}" required min="000000" maxlength="99999999">
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-search"></i> Buscar
                </button>
            </div>
            
        </form>
        
        <form action="{{ url('busqueda') }}" method="POST">
            
            {{ csrf_field() }}
            
            <input type="hidden" name="tipo" value="descripcion">
            
            <div class="form-group">
                <label for="descripcion">Descripción de Producto</label>
                <input type="text" id="descripcion" name="descripcion" class="form-control" value="{{ old('descripcion') }}" maxlength="20" minlength="3" required>
            </div>
            
            <div class="form-check">
                <input type="checkbox" id="activo" name="activo" value="1" class="form-check-input" value="{{ old('activo') }}" checked>
                <label class="form-check-label" for="activo">
                    Activo
                </label>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary">
                    <i class="fa fa-search"></i> Buscar
                </button>
            </div>
            
        </form>
        
        <!--<form action="{{ url('busqueda') }}" method="POST">
            
            {{ csrf_field() }}
            
            <input type="hidden" name="tipo" value="orden">
            
            <div class="form-group">
                <label>Item de Inventario</label>
                <input type="number" name="orden" class="form-control" value="{{ old('orden') }}" min="1" max="9999" required>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary" name="boton" value="buscar">
                    <i class="fa fa-search"></i> Editar
                </button>
                <!--<button type="submit" class="btn btn-danger" name="boton" value="eliminar" onclick="return confirm('Seguro de eliminar?')">
                    <i class="fa fa-trash"></i> Eliminar
                </button>-->
            <!--</div>
            
        </form>-->

    </div>

</div>

@if(session('idavuelta')==2)
<div class="form-group">
    <a class="btn btn-primary" href="{{ url('registro2') }}">
        <i class="fa fa-arrow-left"></i> Regresar
    </a>
</div>
@endif

@if(count($inventarios)>0)

<div class="panel panel-default">
    
    <div class="panel-heading">
        Inventario {{ App\Zona::find($inventarios->first()->zona_id)->nombre }}
    </div>
    
    <table class="table table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Código</th>
                <th>Descripción</th>
                <th>Presentación</th>
                @if(session('idavuelta')==1)
                <th>Ida</th>
                @else
                <th>Vuelta</th>
                @endif
                <th>Ubicación</th>
                <th></th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach($inventarios as $inventario)
            <tr>
                <td>{{ $inventario->orden }}</td>
                <td>{{ $inventario->codigo }}</td>
                <td>{{ $inventario->descripcion }}</td>
                <td>{{ $inventario->presentacion }}</td>
                @if(session('idavuelta')==1)
                <td>{{ $inventario->stock1 }}</td>
                @else
                <td>{{ $inventario->stock2 }}</td>
                @endif
                <td>{{ $inventario->ubicacion }}</td>
                <td>
                    <form action="{{ url('/busqueda/'.$inventario->id) }}" method="POST">
                        {{ csrf_field() }}
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-pencil"></i>
                        </button>
                    </form>
                </td>
                <td>
                    <form action="{{ url('/registro/'.$inventario->id) }}" method="POST">
                        {{ csrf_field() }}
                        {{ method_field('DELETE') }}
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Seguro de eliminar?')">
                            <i class="fa fa-trash"></i>
                        </button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>

@endif

@endsection