<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Zona;

use App\Inventario;

use App\Http\Controllers\Controller;

use App\Ruta;

class ZonaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $zonas = Zona::orderBy('id','asc')->get();
        
        return view('zonas',compact('zonas'));
    }
    
    public function store(Request $request)
    {
        $this->validate($request, [
            'nombre' => 'required|unique:zonas|max:50',
        ]);
        
        $zona = new Zona;
        $zona->nombre = $request->nombre;
        $zona->ida = false;
        $zona->vuelta = true;
        $zona->save();
        
        return redirect('/zonas');
    }
    
    public function delete($id)
    {
        $registros = Inventario::where('zona_id',$id)->get();
        
        if(count($registros)==0)
        {
            Zona::findOrFail($id)->delete();
            session()->flash('mensaje','Zona  eliminada correctamente');
        }
        else
            session()->flash('error','No se puede eliminar por registro en inventario.');
        
        return redirect('/zonas');
    }
    
    public function cerrar_ida($id)
    {
        $zona = Zona::findOrFail($id);
        $zona->ida = !$zona->ida;
        $zona->save();
        
        session()->flash('mensaje','Zona actualizada correctamente');
        
        return redirect('/zonas');
    }
    
    public function cerrar_vuelta($id)
    {
        $zona = Zona::findOrFail($id);
        $zona->vuelta = !$zona->vuelta;
        $zona->save();
        
        session()->flash('mensaje','Zona actualizada correctamente');
        
        return redirect('/zonas');
    }
    
    public function RutaxZona($id)
    {
        $zona = Zona::findOrFail($id);

        $ruta = Ruta::findOrFail(1);
        $ruta->activo = !$zona->ida;
        $ruta->save();
        
        $ruta = Ruta::findOrFail(2);
        $ruta->activo = !$zona->vuelta;
        $ruta->save();
        
        return Ruta::where('activo',1)->get();
    }
}
