<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\User;

use Validator;

use App\Http\Controllers\Controller;

use Hash;

use Auth;

class UserController extends Controller
{
    public function password()
    {
        return View('user.password');
    }
    
    public function updatePassword(Request $request)
    {
        $rules = [
            'mypassword' => 'required',
            'password' => 'required|confirmed|min:4|max:18',
        ];
        
        $messages = [
            'mypassword.required' => 'El campo es requerido',
            'password.required' => 'El campo es requerido',
            'password.confirmed' => 'Los passwords no coinciden',
            'password.min' => 'El mínimo permitido son 4 caracteres',
            'password.max' => 'El máximo permitido son 18 caracteres',
        ];
        
        $validator = Validator::make($request->all(), $rules, $messages);
        
        if ($validator->fails())
        {
            return redirect('user/password')->withErrors($validator);
        }
        else
        {
            if (Hash::check($request->mypassword, Auth::user()->password))
            {
                $user = new User;
                $user->where('email', '=', Auth::user()->email)
                     ->update(['password' => bcrypt($request->password)]);
                return redirect('user/password')->with('mensaje', 'Password cambiado con éxito');
            }
            else
            {
                return redirect('user/password')->with('error', 'Credenciales incorrectas');
            }
        }
    }
}