<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Producto;

use App\Inventario;

use App\Zona;

class Registro2Controller extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function store(Request $request)
    {
        $zona = Zona::findOrFail(session('zona_id'));
        
        if((session('idavuelta')==1 and $zona->ida==1) or (session('idavuelta')==2 and $zona->vuelta==1))
            return redirect('inicio');
        
        $this->validate($request, [
            'codigo' => 'required|max:8|min:6',
            'descripcion' => 'required|max:70|min:3',
            'presentacion' => 'required|max:15|min:3',
            'lote' => 'max:20|min:1',
            'cantidad' => 'required',
            'ubicacion' => 'max:20'
        ]);
        
        date_default_timezone_set("America/Lima");
        $fechahora = date('Y-m-d H:i:s');
        
        //$registros = Inventario::where('zona_id',session('zona_id'))->get();
        
        //$inventario = Inventario::where('codigo',$request->codigo)->first();
        //if($inventario == null)
        if ($request->modo == 'nuevo')
        {
            $inventario = new Inventario;
        }
        else
        {
            $inventario = Inventario::where('zona_id', session('zona_id'))->where('orden', $request->orden)->first();
        }
        $inventario->orden = $request->orden; //count($registros)+1;
        $inventario->codigo = $request->codigo;
        $inventario->descripcion = $request->descripcion;
        $inventario->presentacion = $request->presentacion;
        $inventario->lote = $request->lote;
        $inventario->ubicacion = $request->ubicacion;
        
        if(session('idavuelta') == 1)
        {
            $inventario->stock1 = $request->cantidad;
            $inventario->fechahora1 = $fechahora;
        }
        elseif(session('idavuelta') == 2)
        {
            $inventario->stock2 = $request->cantidad;
            $inventario->fechahora2 = $fechahora;
        }
        $inventario->user_id = auth()->user()->id;
        $inventario->zona_id = session('zona_id');
        $inventario->save();
        
        session()->flash('mensaje',"Item $inventario->orden de inventario grabado");
        
        if(session('idavuelta')==1)
        {
            return redirect('/busqueda');
        }
        else
        {
            return redirect('/busqueda2');
        }
    }
    
    public function delete($id)
    {
        $inventario = Inventario::findOrFail($id);
        $item = $inventario->orden;
        $inventario->delete();
        
        session()->flash('error',"Item $item eliminado");
        
        return redirect('/busqueda2');
    }
}
