<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Producto;

use App\Inventario;

use App\Zona;

use App\Lote;

class ProductoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        $zona = Zona::findOrFail(session('zona_id'));
        
        if((session('idavuelta')==1 and $zona->ida==1) or (session('idavuelta')==2 and $zona->vuelta==1))
            return redirect('inicio');
            
        if(session('idavuelta')==2) $order='desc';
        elseif(session('idavuelta')==1) $order='desc';
        
        $inventarios = Inventario::where('zona_id', session('zona_id'))->where('stock2',0)->orderBy('orden', $order)->orderBy('id')->get();
        
        return view('busqueda', compact('inventarios'));
    }
    
    public function search(Request $request)
    {
        $inventario = new Inventario;
        
        if($request->tipo == "codigo")
        {
            $this->validate($request, [
                'codigo' => 'min:6|max:8|exists:pro_tbmaterial,MatV_Codigo'
            ]);
            
            $producto = Producto::where('MatV_Codigo', $request->codigo)->first();
            
            //$registros = Inventario::where('zona_id',session('zona_id'))->get();
            //$orden = count($registros) + 1;
            $orden = Inventario::where('zona_id',session('zona_id'))->max('orden') + 1;
            
            $modo = 'nuevo';
        }
        else if($request->tipo == "descripcion")
        {
            $this->validate($request, [
                'descripcion' => 'min:3' //|exists:pro_tbmaterial,MatV_Desc
            ]);
            
            $activo = $request->has('activo') ? 1 : 0;
            
            $productos = Producto::where('MatV_Desc', 'like', '%'.$request->descripcion.'%')->where('activo',$activo)->get();
            
            return view('productos',compact('productos'));
        }
        else if($request->tipo == "orden")
        {
            $this->validate($request, [
                'orden' => 'min:1' //|exists:inventario,orden
            ]);
            
            $orden = $request->orden;
                
            $inventario = Inventario::where('zona_id',session('zona_id'))->where('orden', $orden)->orderBy('id','desc')->first();
            
            if($inventario == null)
            {
                session()->flash('error',"Item $orden no encontrado");
                
                return redirect('busqueda');
            }
                
            if($request->boton == "buscar")
            {
                $producto = Producto::where('MatV_Codigo', $inventario->codigo)->first();
                
                $modo = 'edicion';
            }
            else if($request->boton == "eliminar")
            {
                $inventario->delete();
                
                session()->flash('error',"Item $orden eliminado");
                
                return redirect('busqueda');
            }
        }
        
        $lotes = Lote::where('codigo', $producto->MatV_Codigo)->orderBy('lote')->get();
        
        return view('registro', compact('producto','orden','modo','lotes','inventario'));
    }
    
    public function buscarxid($id)
    {
        $inventario = Inventario::find($id);
        
        //return $inventario;
        
        $producto = Producto::where('MatV_Codigo', $inventario->codigo)->first();
        
        $orden = $inventario->orden;
        
        $modo = 'edicion';
        
        $lotes = Lote::where('lote', $inventario->lote)->get();
        
        return view('registro', compact('producto','orden','modo','lotes','inventario'));
    }
    
    public function searchxcodigo($codigo)
    {
        session()->flash('error',"");
        session()->flash('mensaje',"");
        
        $producto = Producto::where('MatV_Codigo', $codigo)->first();
        
        $orden = Inventario::where('zona_id',session('zona_id'))->max('orden') + 1;
        
        $modo = 'nuevo';
        
        $lotes = Lote::where('codigo', $producto->MatV_Codigo)->orderBy('lote')->get();
        
        return view('registro', compact('producto','orden','modo','lotes'));
    }
}
